﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;

namespace TextBoxInfoCompositeControl
{
    /// <summary>
    /// Summary description for ServerControl1
    /// </summary>
    public class TextBoxInfo : CompositeControl, IScriptControl
    {
        ScriptManager _scriptManager;
        TextBox _dataEntryTextBox;
        Image _informationImageButton;
        Table _pageLayoutTable;
       
        public TextBoxInfo()
        {
        }
        
        public string Text
        {
            get { EnsureChildControls(); return _dataEntryTextBox.Text; }
            set { EnsureChildControls(); _dataEntryTextBox.Text = value; }
        }

        public string ImageUrl
        {
            get { EnsureChildControls(); return _informationImageButton.ImageUrl; }
            set { EnsureChildControls(); _informationImageButton.ImageUrl = value; }
        }

        public string InformationText { get; set; }
        
        protected override HtmlTextWriterTag TagKey
        {
            get
            {
                return HtmlTextWriterTag.Div;
            }
        }

        protected override void CreateChildControls()
        {
            Controls.Clear();

            _pageLayoutTable = new Table();
            _pageLayoutTable.ID = "pageLayoutTable";
            Controls.Add(_pageLayoutTable);
            
            _dataEntryTextBox = new TextBox();
            _dataEntryTextBox.ID = "DataEntryTextBox";
            Controls.Add(_dataEntryTextBox);

            _informationImageButton = new Image();
            _informationImageButton.ID = "HelpIconImageButton";
            Controls.Add(_informationImageButton);

            ChildControlsCreated = true;
        }

        protected override void RenderContents(HtmlTextWriter writer)
        {
            TableRow row = new TableRow();
            TableCell textBoxCell = new TableCell();
            textBoxCell.Controls.Add(_dataEntryTextBox);
            TableCell informationImageCell = new TableCell();
            informationImageCell.Controls.Add(_informationImageButton);
            row.Cells.Add(textBoxCell);
            row.Cells.Add(informationImageCell);
            _pageLayoutTable.Rows.Add(row);
            _pageLayoutTable.RenderControl(writer);
        }


        #region IScriptControl CompositeControl Overrides
        
        protected override void OnPreRender(EventArgs e)
        {
            if (!DesignMode)
            {
                _scriptManager = ScriptManager.GetCurrent(Page);

                if (_scriptManager == null)
                    throw new HttpException("ScriptManager must be on the page for the TextBoxInfo control to work properly");

                _scriptManager.RegisterScriptControl<TextBoxInfo>(this);
            }
            
            base.OnPreRender(e);
        }

        protected override void Render(HtmlTextWriter writer)
        {
            if (!base.DesignMode)
                _scriptManager.RegisterScriptDescriptors(this);
            
            base.Render(writer);
        }
        
        #endregion


        #region IScriptControl Members

        IEnumerable<ScriptDescriptor> IScriptControl.GetScriptDescriptors()
        {
            ScriptControlDescriptor descriptor = new ScriptControlDescriptor("TextBoxInfoCompositeControl.TextBoxInfo", this.ClientID);
            descriptor.AddElementProperty("textBoxElement", _dataEntryTextBox.ClientID);
            descriptor.AddElementProperty("imageElement", _informationImageButton.ClientID);
            descriptor.AddProperty("informationText", InformationText);
            yield return descriptor;
        }

        IEnumerable<ScriptReference> IScriptControl.GetScriptReferences()
        {
            yield return new ScriptReference("TextBoxInfoCompositeControl.TextBoxInfo.js", this.GetType().Assembly.FullName);
        }

        #endregion
    }
}